<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Http\Requests\QuarterlyReportRequest;
use App\Models\QuarterlyReport;
use Illuminate\Http\Request;

class QuarterlyReportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $reports = QuarterlyReport::latest()->get();
        return response()->json($reports);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(QuarterlyReportRequest $request)
    {
        $data = $request->validated();
            $data['creationDate'] = now(); // Auto-generate current timestamp

            $report = QuarterlyReport::create($data);

            return response()->json([
                'message' => 'Quarterly Report Created Successfully.',
                'data' => $report,
            ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $report = QuarterlyReport::find($id);

        if (!$report) {
         return response()->json(['error' => 'Report Not Found'], 404);
                }

        return response()->json($report, 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(QuarterlyReportRequest $request, string $id)
    {
         $report = QuarterlyReport::find($id);

                if (!$report) {
                    return response()->json(['error' => 'Report Not Found'], 404);
                }

                $report->update($request->validated());

                return response()->json([
                    'message' => 'Quarterly Report Updated',
                    'data' => $report
                ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $report = QuarterlyReport::find($id);

            if (!$report) {
                return response()->json(['error' => 'Report not found'], 404);
            }

            $report->delete();

            return response()->json(['message' => 'Quarterly Report Deleted']);
    }
}
