<?php
use App\Http\Controllers\Controller;
use App\Services\RegionsService;

class RegistrationController extends Controller
{
    protected RegionsService $regionsService;

    public function __construct(RegionsService $regionsService)
    {
        $this->regionsService = $regionsService;
    }

    public function showForm()
    {
        $regions = $this->regionsService->all();
        return view('registration.form', compact('regions'));
    }

    public function getProvinces($regionName)
    {
        $provinces = $this->regionsService->provinces($regionName);
        return response()->json($provinces);
    }
}
