<?php

namespace App\Http\Controllers\APIs;

use App\Http\Controllers\Controller;
use App\Http\Requests\SecretaryNoteRequest;
use App\Models\SecretaryNote;
use Illuminate\Http\Request;

class SecretaryNoteController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $notes = SecretaryNote::latest()->get();
        return response()->json($notes);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(SecretaryNoteRequest $request)
    {
        $data = $request->validated();
            $data['createdDate'] = now(); // Auto-generate current timestamp

            $notes = SecretaryNote::create($data);

            return response()->json([
                'message' => 'Secretary Note Created Successfully.',
                'data' => $notes,
            ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $notes = SecretaryNote::find($id);

        if (!$notes) {
         return response()->json(['error' => 'Note Record Not Found'], 404);
                }

        return response()->json($notes, 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(SecretaryNoteRequest $request, string $id)
    {
         $notes = SecretaryNote::find($id);

                if (!$notes) {
                    return response()->json(['error' => 'Note Record Not Found'], 404);
                }

                $notes->update($request->validated());

                return response()->json([
                    'message' => 'Note Minutes Updated',
                    'data' => $notes
                ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $notes = SecretaryNote::find($id);

            if (!$notes) {
                return response()->json(['error' => 'Note Record not found'], 404);
            }

            $notes->delete();

            return response()->json(['message' => 'Note Minutes Deleted']);
    }
}
