<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AttendanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'conference_id' => 'required|exists:conferences,id', // ✅ Validate user exists
            'arrival_time' => 'required|date',
            // 'departure_time' => 'nullable|date|after:arrival_time',
            'comments' => 'nullable|string|max:255',
        ];
    }
}
