<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
       // Allow access only if the user is logged in AND has either 'admin' or 'super_admin' role.
        return Auth::check() && in_array(Auth::user()?->role, ['SUPER_ADMIN', 'ADMIN', 'SECRETARY', 'TREASURER', 'USER']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'name' is required, must be a string, and cannot exceed 255 characters
            'name' => 'required|string|max:255',

            // 'surname' is required, must be a string, and cannot exceed 255 characters
            'surname' => 'required|string|max:255',

            // 'email' is required, must be a valid email format, and must be unique in the 'users' table
            'email' => 'required|email|unique:users,email',

            // 'role' is required and must be either 'super_admin' or 'admin'
            'role' => 'required|in:SUPER_ADMIN,ADMIN,SECRETARY,TREASURER,USER'
        ];
    }
}
