<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SecretaryNoteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

     private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    //private const REQUIRED_INTEGER_MAX_255 = 'required|int|max:255';
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
            'meetingVenue' => 'required|string|max:255',
            'meetingAnchor' => self::REQUIRED_STRING_MAX_255,
            'attendanceMen' => self::REQUIRED_STRING_MAX_255,
            'attendanceWomen' => self::REQUIRED_STRING_MAX_255,
            'attendanceChildren' => self::NULLABLE_STRING_MAX_255,
            'attendanceTotal' => self::REQUIRED_STRING_MAX_255,
            'detailOfMeeting' => self::REQUIRED_STRING_MAX_255,
            'actionablePoints' => self::REQUIRED_STRING_MAX_255,
            'actionablePointsAssigned' => self::REQUIRED_STRING_MAX_255,
            'meetingDate' => 'required|string'

        ];
    }
}
