<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SpecialProjectsReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    private const REQUIRED_INTEGER_MAX_255 = 'required|int|max:255';

    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'projectName' => 'required|string|max:255',
            'projectDescription' => self::REQUIRED_STRING_MAX_255,
            'projectLocation' => self::REQUIRED_STRING_MAX_255,
            'state' => self::REQUIRED_STRING_MAX_255,
            'projectEstimate' =>self::NULLABLE_STRING_MAX_255,
            'projectCost' =>self::REQUIRED_STRING_MAX_255,
            'projectStartDate' => self::NULLABLE_STRING_MAX_255,
            'projectCompletedDate' => self::REQUIRED_STRING_MAX_255,
            'projectManager' => self::REQUIRED_STRING_MAX_255,
            'projectAid' => self::NULLABLE_STRING_MAX_255,
            'projectRemarks' => self::NULLABLE_STRING_MAX_255,

        ];
    }
}
