<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreMonthlyReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    private const REQUIRED_STRING_MAX_255 = 'required|string|max:255';
    private const NULLABLE_STRING_MAX_255 = 'nullable|string|max:255';

    private const REQUIRED_INTEGER_MAX_255 = 'required|int|max:255';
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'state' => 'required|string|max:50',
            'region' => self::REQUIRED_STRING_MAX_255,
            'province' => self::REQUIRED_STRING_MAX_255,
            'coordinator_name' => self::REQUIRED_STRING_MAX_255,
            'prison_visited' =>self::NULLABLE_STRING_MAX_255,
            'hospital_visited' =>self::NULLABLE_STRING_MAX_255,
            'police_station_visited' => self::NULLABLE_STRING_MAX_255,
            'others' => self::NULLABLE_STRING_MAX_255,
            'items' => self::REQUIRED_STRING_MAX_255,
            'amount_budgeted' => self::NULLABLE_STRING_MAX_255,
            'amount_spent' => self::REQUIRED_STRING_MAX_255,
            'team_members' => self::REQUIRED_STRING_MAX_255,
            'souls_won' => self::REQUIRED_INTEGER_MAX_255,
            'challenges' => self::REQUIRED_STRING_MAX_255,
            'suggestion' => self::NULLABLE_STRING_MAX_255,
            'remarks' => self::REQUIRED_STRING_MAX_255,
            'report_created_by' => self::REQUIRED_STRING_MAX_255,
            'activity_date' => 'required|string',

        ];
    }
}
