<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conferences', function (Blueprint $table) {
            $table->id();
            $table->string('conference_date');
            $table->string('conference_theme');
            $table->string('full_name');
            $table->string('email')->unique();
            $table->string('phone_number');
            $table->string('state');
            $table->string('region');
            $table->string('province');
            $table->string('position');
            $table->boolean('accommodation')->default(false);
            $table->string('arrival_date')->nullable();
            $table->string('departure_date')->nullable();
            $table->boolean('first_timer')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conferences');
    }
};
