<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('secretary_notes', function (Blueprint $table) {
            $table->id();
            $table->string('meetingVenue');
            $table->string('meetingAnchor');
            $table->string('attendanceMen');
            $table->string('attendanceWomen');
            $table->string('attendanceChildren');
            $table->string('attendanceTotal');
            $table->string('detailOfMeeting');
            $table->string('actionablePoints');
            $table->string('actionablePointsAssigned');
            $table->string('meetingDate');
            $table->dateTime('createdDate')->useCurrent();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('secretary_notes');
    }
};
