<?php

use App\Http\Controllers\APIs\AttendanceController;
use App\Http\Controllers\APIs\ConferenceController;
use App\Http\Controllers\APIs\MonthlyDuePaymentController;
use App\Http\Controllers\APIs\NationalReportController;
use App\Http\Controllers\APIs\QuarterlyReportController;
use App\Http\Controllers\APIs\SecretaryNoteController;
use App\Http\Controllers\APIs\SpecialProjectsReportController;
use App\Http\Controllers\APIs\StateCoordinatorController;
use App\Http\Controllers\APIs\TodoListController;
use App\Http\Controllers\APIs\UsersController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\NationalDBUserProfileController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\MonthlyReportController;
use Illuminate\Container\Attributes\Auth;

 // Conference Routes
Route::prefix('conference')->controller(ConferenceController::class)->group(function () {
    Route::get('/all', 'index')->name('conference.all');  // Get all forms
    Route::post('/register', 'register')->name('conference.register');  // Create form
    Route::get('/{id}', 'show')->name('conference.show');  // Get form by ID
    Route::put('/update/{id}', 'update')->name('conference.update');  // Update form
    Route::delete('/delete/{id}', 'destroy')->name('conference.delete');  // Delete form
});

 // Users For Authentication Routes
Route::prefix('user')->controller(UsersController::class)->group(function () {
    Route::post('/register', 'register');
    Route::post('/login', 'login');
    Route::get('/dashboard', 'dashboard');
    Route::post('/logout', 'logout');
});

 // Attendance Routes
 Route::prefix('attendance')->group(function () {
    Route::get('/users', [AttendanceController::class, 'getUsers']); // ✅ Fetch registered users
    Route::post('/register', [AttendanceController::class, 'register']); // ✅ Submit attendance
    Route::get('/all', [AttendanceController::class, 'fetchAll']); // ✅ Fetch attendance records
    Route::patch('/admin/{id}', [AttendanceController::class, 'admin']); // ✅ Admin acknowledges attendance
});

//UserProfile Routes
Route::prefix('userProfile')->group(function () {
    Route::get('/regions', [NationalDBUserProfileController::class, 'regions']);
    Route::get('/provinces/{region}', [NationalDBUserProfileController::class, 'provinces']);
    Route::get('/states', [NationalDBUserProfileController::class, 'states']);
    Route::get('/lgas/{state}', [NationalDBUserProfileController::class, 'lgas']);

    // Usual CRUD routes
    Route::post('/createUser', [NationalDBUserProfileController::class, 'store']);
    Route::put('/updateUser/{id}', [NationalDBUserProfileController::class, 'update']);
    Route::get('/getAllUsers', [NationalDBUserProfileController::class, 'index']); // 🆕 Fetch ALL profiles
    Route::get('/getUser/{id}', [NationalDBUserProfileController::class, 'show']);
    Route::delete('/deleteUser/{id}', [NationalDBUserProfileController::class, 'destroy']);
});

//Monthly Report Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,SECRETARY,TREASURER,USER'])
    ->prefix('monthlyReports')
    ->group(function () {
        Route::get('/getAllReports', [MonthlyReportController::class, 'index']);
        Route::get('/regions', [MonthlyReportController::class, 'regions']);
        Route::get('/provinces/{region}', [MonthlyReportController::class, 'provinces']);
        Route::post('/createReport', [MonthlyReportController::class, 'store']);
        Route::get('/getReport/{id}', [MonthlyReportController::class, 'show']);
        Route::put('/updateReport/{id}', [MonthlyReportController::class, 'update']);
        Route::delete('/deleteReport/{id}', [MonthlyReportController::class, 'destroy']);
    });


//State Coordinators API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,SECRETARY,TREASURER,USER'])
    ->prefix('stateCoordinators')
    ->group(function () {
        Route::get('/getAll', [StateCoordinatorController::class, 'index']);   // List all
        Route::post('/create', [StateCoordinatorController::class, 'store']); // Create new
        Route::get('/getUser/{id}', [StateCoordinatorController::class, 'show']); // Get A Single User
        Route::put('/updateUser/{id}', [StateCoordinatorController::class, 'update']); // Update A User
        Route::delete('/deleteUser/{id}', [StateCoordinatorController::class, 'destroy']); // Delete A User
        Route::get('/states', [StateCoordinatorController::class, 'states']); // Get state list
    });


//National Report API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN'])
    ->prefix('nationalReport')
    ->group(function () {
        Route::get('/getAllReport', [NationalReportController::class, 'index']);   // List all Report
        Route::post('/createReport', [NationalReportController::class, 'store']); // Create new Report
        Route::get('/getReport/{id}', [NationalReportController::class, 'show']); // Get A Single Report
        Route::put('/updateReport/{id}', [NationalReportController::class, 'update']); // Update A Report
        Route::delete('/deleteReport/{id}', [NationalReportController::class, 'destroy']); // Delete A Report
    });


//Quarterly Report API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN'])
    ->prefix('quarterlyReport')
    ->group(function () {
        Route::get('/getAllReport', [QuarterlyReportController::class, 'index']);   // List all Report
        Route::post('/createReport', [QuarterlyReportController::class, 'store']); // Create new Report
        Route::get('/getReport/{id}', [QuarterlyReportController::class, 'show']); // Get A Single Report
        Route::put('/updateReport/{id}', [QuarterlyReportController::class, 'update']); // Update A Report
        Route::delete('/deleteReport/{id}', [QuarterlyReportController::class, 'destroy']); // Delete A Report
    });


//Secretary Notes API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,SECRETARY'])
    ->prefix('secretaryNote')
    ->group(function () {
        Route::get('/getAllNotes', [SecretaryNoteController::class, 'index']);   // List all Notes
        Route::post('/createNote', [SecretaryNoteController::class, 'store']); // Create new Note
        Route::get('/getNote/{id}', [SecretaryNoteController::class, 'show']); // Get A Single Note
        Route::put('/updateNote/{id}', [SecretaryNoteController::class, 'update']); // Update A Note
        Route::delete('/deleteNote/{id}', [SecretaryNoteController::class, 'destroy']); // Delete A Note
    });


//Special Project Report API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,SECRETARY,TREASURER,USER'])
    ->prefix('specialProjects')
    ->group(function () {
        Route::get('/getAllProjects', [SpecialProjectsReportController::class, 'index']);   // List all Report
        Route::post('/createReport', [SpecialProjectsReportController::class, 'store']); // Create new Report
        Route::get('/getReport/{id}', [SpecialProjectsReportController::class, 'show']); // Get A Single Report
        Route::put('/updateReport/{id}', [SpecialProjectsReportController::class, 'update']); // Update A Report
        Route::delete('/deleteReport/{id}', [SpecialProjectsReportController::class, 'destroy']); // Delete A Report
    });



//Monthly Dues Report API Routes
Route::prefix('monthlyDues')->group(function () {
    Route::get('/getAllReport', [MonthlyDuePaymentController::class, 'index']);   // List all Report
    Route::post('/createReport', [MonthlyDuePaymentController::class, 'store']); // Create new Report
    Route::get('/getReport/{id}', [MonthlyDuePaymentController::class, 'show']); // Get A Single Report
    Route::put('/updateReport/{id}', [MonthlyDuePaymentController::class, 'update']); // Update A Report
    Route::delete('/deleteReport/{id}', [MonthlyDuePaymentController::class, 'destroy']); // Delete A Report

});

Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,TREASURER'])
    ->prefix('monthlyDues')
    ->group(function () {
        Route::get('/getAllReport', [MonthlyDuePaymentController::class, 'index']);   // List all Report
        Route::post('/createReport', [MonthlyDuePaymentController::class, 'store']); // Create new Report
        Route::get('/getReport/{id}', [MonthlyDuePaymentController::class, 'show']); // Get A Single Report
        Route::put('/updateReport/{id}', [MonthlyDuePaymentController::class, 'update']); // Update A Report
        Route::delete('/deleteReport/{id}', [MonthlyDuePaymentController::class, 'destroy']); // Delete A Report
    });


//TodoList API Routes
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN,SECRETARY,TREASURER,USER'])
    ->prefix('todoList')
    ->group(function () {
        Route::get('/getAllList', [TodoListController::class, 'index']);
        Route::post('/createList', [TodoListController::class, 'store']);
        Route::get('/getList/{id}', [TodoListController::class, 'show']);
        Route::put('/updateList/{id}', [TodoListController::class, 'update']);
        Route::delete('/deleteList/{id}', [TodoListController::class, 'destroy']);

        // 👇 Custom updates
        Route::patch('/status/{id}', [TodoListController::class, 'updateStatus']);
        Route::patch('/priority/{id}', [TodoListController::class, 'updatePriority']);
    });


// 🔹 Public Authentication Routes (No Authentication Required)
Route::prefix('userManager')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);   // Login user
    Route::match( ['get', 'post'], '/accountActivation', [AuthController::class, 'activateAccount'])
    ->middleware('throttle:5,1'); // Activate Account
});

// 🔹 Super Admin Routes (Restricted to Super Admin Only))
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN'])-> prefix('userManager')->group(function () {
    Route::post('/createUser', [AuthController::class, 'createUser']);   // Create User
});

// 🔹 Authenticated User Routes (Requires Login)
Route::middleware(['auth:sanctum'])->prefix('userManager')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']); // Logout
    Route::post('/passwordChange', [AuthController::class, 'changePassword']); // Change Password
    Route::get('/getUser', [AuthController::class, 'userDetails']); // Get Logged-in User Profile
});

// 🔹 Admin & Super Admin Routes (Restricted to Admins & Super Admins)
Route::middleware(['auth:sanctum', 'role:SUPER_ADMIN,ADMIN'])->prefix('userManager')->group(function () {
    Route::get('getAllUsers', [AuthController::class, 'listUsers']); // List All Users
    Route::get('getAUser/{id}', [AuthController::class, 'getUser']); // Get Specific User
    Route::put('/updateUser/{id}', [AuthController::class, 'updateUser']); // Update User
    Route::delete('/deleteUser/{id}', [AuthController::class, 'deleteUser']); // Delete User
});



